#!/bin/bash

# 
# Script file to set up desktop integration components
# J. Newberry, Applied Precision, LLC
# 15 December 2003
#


SWBASE=/usr/local/softWoRx

DTBASE=$SWBASE/config/desktop

# See how we were called.
case "$1" in
  install)
    #############################
    # Shared things
    #############################
    echo "Installing common desktop integration components"
    
    
    cp $DTBASE/deltavision-image.png /usr/share/pixmaps/deltavision-image.png
    
    cp $SWBASE/config/pixmaps/sw_app_icon.xpm  /usr/share/pixmaps/sw_app_icon.xpm
    cp $SWBASE/config/pixmaps/sw_stop_icon.xpm /usr/share/pixmaps/sw_stop_icon.xpm
    cp $SWBASE/config/pixmaps/acquire_ultra.png /usr/share/pixmaps/acquire_ultra.png
    
    cp $DTBASE/dvview.desktop  /usr/share/applications/dvview.desktop
    
    ## Redhat Enterprise Linux 4 uses a different opendesktop.org spec than EL-3 ##
    EL4_DESKTOP=/etc/xdg/menus
    if [ -e $EL4_DESKTOP ] ; then
    
        cp $DTBASE/swstart.desktop_EL4 /usr/share/applications/swstart.desktop
        cp $DTBASE/swexit.desktop_EL4  /usr/share/applications/swexit.desktop
        cp $DTBASE/acquire_ultra.desktop_EL4  /usr/share/applications/acquire_ultra.desktop
        cp $DTBASE/stop_acquire_ultra.desktop_EL4  /usr/share/applications/stop_acquire_ultra.desktop
        cp $DTBASE/dvultra_objective.desktop_EL4 /usr/share/applications/dvultra_objective.desktop
       
        cp $DTBASE/softworx.xml /usr/share/mime/packages/softworx.xml
        
        cp $DTBASE/GEHealthcare.directory /usr/share/desktop-directories/GEHealthcare.directory
        cp $DTBASE/gehealthcare.menu      /etc/xdg/menus/applications-merged/gehealthcare.menu

        /usr/bin/update-mime-database /usr/share/mime >& /dev/null
        /usr/bin/update-desktop-database /usr/share/applications >& /dev/null
    else
    
        cp $DTBASE/swstart.desktop /usr/share/applications/swstart.desktop
        cp $DTBASE/swexit.desktop  /usr/share/applications/swexit.desktop
        
        cp $DTBASE/GEHealthcare.directory /usr/share/desktop-menu-files/GEHealthcare.directory

        # Modify desktop menus configuration files by adding arrayWoRx sections
        (cd $DTBASE; ./insert_lines.sh /etc/X11/desktop-menus/applications.menu Accessories)
        (cd $DTBASE; ./insert_lines.sh /etc/X11/desktop-menus/start-here.menu Accessories)
    fi
    
    #############################
    # Gnome desktop mime configuration
    #############################

    echo "Installing Gnome desktop integration components"

    EL4_DESKTOP=/etc/xdg/menus
    if [ ! -e $EL4_DESKTOP ] ; then
      # Remove any deltavision entries from the mime-magic file
    
      cp $DTBASE/softworx.keys /usr/share/mime-info/softworx.keys
      cp $DTBASE/softworx.mime /usr/share/mime-info/softworx.mime
      cp $DTBASE/softworx.applications /usr/share/application-registry/softworx.applications
      cp /etc/gnome-vfs-mime-magic /tmp/gnome_mime
      fgrep -v "deltavision" /tmp/gnome_mime > /etc/gnome-vfs-mime-magic
      rm /tmp/gnome_mime
        
      # Prepend deltavision entries
      mv /etc/gnome-vfs-mime-magic /etc/gnome-vfs-mime-magic.ap_save
    
      cat $DTBASE/mime-magic > /etc/gnome-vfs-mime-magic
      cat /etc/gnome-vfs-mime-magic.ap_save >> /etc/gnome-vfs-mime-magic
    fi
        
    #############################
    # KDE desktop mime configuration
    #############################
    APPLNK=/usr/share/applnk
    if [ ! -e $APPLNK ] ; then
        APPLNK=/usr/share/applnk-redhat
    fi
    
    # to see if KDE is installed...
    if [ -e $APPLNK ] ; then
    
        echo "Installing KDE desktop integration components"
        
        # for KDE, this needs to go here, too
        if [ ! -e $APPLNK/Graphics ] ; then
            mkdir $APPLNK/Graphics
        fi
        cp $DTBASE/dvview.desktop  $APPLNK/Graphics/dvview.desktop
        
        # DeltaVision image file 
        cp $DTBASE/deltavision.desktop /usr/share/mimelnk/image/deltavision.desktop

        # remove any deltavision entries from the mime magic file for KDE
        cp /usr/share/mimelnk/magic /tmp/kde_mime
        fgrep -v "deltavision" /tmp/kde_mime > /usr/share/mimelnk/magic
        mv /usr/share/mimelnk/magic /usr/share/mimelnk/magic.ap_save
        rm /tmp/kde_mime

        # Prepend deltavision entries
        cat $DTBASE/mime-magic > /usr/share/mimelnk/magic
        cat /usr/share/mimelnk/magic.ap_save >> /usr/share/mimelnk/magic
        
        # Remove some things that get in the way. KDE defines kaboodle
        # and noatun as handlers for video/mpeg even though they are
        # really audio players. Do this to make xine the preferred
        # handler.
        
        if [ ! -e /usr/share/ap_save ] ; then
            mkdir /usr/share/ap_save
        fi
        
        if [ -e /usr/share/applications/kde-noatun.desktop ] ; then
            mv /usr/share/applications/kde-noatun.desktop /usr/share/ap_save
        fi
        
        if [ -e /usr/share/applications/kde-kaboodle.desktop ] ; then
            mv /usr/share/applications/kde-kaboodle.desktop /usr/share/ap_save
        fi

        # Make sure kde doesn't try to override DeltaVision's colors
        if [ -e /usr/share/config/kcmdisplayrc ] ; then
            mv /usr/share/config/kcmdisplayrc /usr/share/ap_save
        fi
        cp $DTBASE/kcmdisplayrc /usr/share/config/kcmdisplayrc
        
        # Set the default "service" for application log files
        # This will set konqueror to use the "Advanced Text Editor"
        # embedded service for mime type text/x-log which is already
        # defined, but defined as a directory??
        KATEPART=/usr/share/services/katepart.desktop
        
        if [ -e $KATEPART ] ; then
        
            KATEPART2=${KATEPART}_apsave
            grep -q "x-log" $KATEPART 
            # if x-log is not already on the MimeType line, append it to the line
            if [ $? == 1 ] ; then
                # move existing file to temp named file
                mv $KATEPART $KATEPART2

                # copy all lines from temp file to real file except MimeType line
                grep --invert-match "MimeType=" $KATEPART2 > $KATEPART

                # copy the MimeType line appending the text/x-log definition to it
                awk '/MimeType=/ { printf "%s;text/x-log\n", $0 }' $KATEPART2 >> $KATEPART

                # remove temporary file
                rm $KATEPART2
            fi
        fi
    fi
    ;;
    
  uninstall)
    echo "Removing softWoRx desktop integration components"
    #############################
    # Shared things
    #############################
    rm /usr/lib/X11/app-defaults/softWoRx
    
    rm /usr/share/pixmaps/deltavision-image.png
    rm /usr/share/pixmaps/sw_app_icon.xpm
    rm /usr/share/pixmaps/acquire_ultra.png
    rm /usr/share/pixmaps/sw_stop_icon.xpm
    
    rm /usr/share/applications/swstart.desktop
    rm /usr/share/applications/swexit.desktop
    rm /usr/share/applications/dvview.desktop
    rm /usr/share/applications/dvmpeg.desktop
    rm /usr/share/applications/acquire_ultra.desktop
    rm /usr/share/applications/stop_acquire_ultra.desktop
    rm /usr/share/applications/dvultra_objective.desktop 
    
    ## EL-4 things ##
    if [ -f /usr/share/desktop-directories/GEHealthcare.directory ] ; then
        rm /usr/share/desktop-directories/GEHealthcare.directory
    fi
    
    if [ -f /etc/xdg/menus/applications-merged/gehealthcare.menu ] ; then
        rm /etc/xdg/menus/applications-merged/gehealthcare.menu
    fi

    if [ -f /usr/share/mime/packages/softworx.xml ] ; then
        rm /usr/share/mime/packages/softworx.xml
    fi
    
    /usr/bin/update-mime-database /usr/share/mime
    /usr/bin/update-desktop-database /usr/share/applications

    ## EL-3 things  ##
    if [ -f /usr/share/desktop-menu-files/GEHealthcare.directory ] ; then
        rm /usr/share/desktop-menu-files/GEHealthcare.directory
    fi
    
    # Remove lines in desktop menu configuration files
    if [ -f /etc/X11/desktop-menus/applications.menu ]; then
        fgrep --invert-match "softWoRx" /etc/X11/desktop-menus/applications.menu > /tmp/save.menu
        mv /tmp/save.menu /etc/X11/desktop-menus/applications.menu
    fi
    
    if [ -f /etc/X11/desktop-menus/start-here.menu ] ; then
        fgrep --invert-match "softWoRx" /etc/X11/desktop-menus/start-here.menu > /tmp/save.menu
        mv /tmp/save.menu /etc/X11/desktop-menus/start-here.menu   
    fi 
    
    #############################
    # Gnome desktop configuration
    #############################
    
    if [ -f /usr/share/mime-info/softworx.keys ]; then
      rm -f /usr/share/mime-info/softworx.keys
    fi

    if [ -f /usr/share/application-registry/softworx.applications ]; then
      rm -f /usr/share/application-registry/softworx.applications
    fi

    if [ -f /etc/gnome-vfs-mime-magic.ap_save ] ; then
        cp /etc/gnome-vfs-mime-magic.ap_save /etc/gnome-vfs-mime-magic
    fi
    
    #############################
    # KDE desktop configuration
    #############################
    if [ -f /usr/share/mimelnk/image/deltavision.desktop ] ; then
        rm  /usr/share/mimelnk/image/deltavision.desktop
    fi
    
    if [ -f /usr/share/mimelnk/magic.ap_save ] ; then
        cp /usr/share/mimelnk/magic.ap_save /usr/share/mimelnk/magic
    fi
    
    if [ -f /usr/share/ap_save ] ; then
        mv /usr/share/ap_save/* /usr/share/applications
        rmdir /usr/share/ap_save
    fi
    
    if [ -f /usr/share/applnk-redhat/Graphics/dvview.desktop ] ; then
        rm /usr/share/applnk-redhat/Graphics/dvview.desktop
    fi
    
    ;;
 *)
    echo "usage: $0 {install | uninstall}"
    exit -1
esac

exit 0
