#!/bin/bash
#
# usage: insert_lines.sh filename section_name
#
# Insert a section in to a desktop menu file before the specified
# section
# J. Newberry 16 Dec 2003

FILE_TO_INSERT=desktop-menus-softworx-part

if [ $# != 2 ] ; then
    echo "usage: insert_lines.sh filename section_name"
    exit -1
fi

# First remove any softWoRx entries
fgrep --invert-match "softWoRx" $1 > /tmp/save.menu
mv /tmp/save.menu $1

# Determine the length of the file (cut has a fixed column output)
FILE_LEN=`wc --lines $1 | cut --bytes='0-7' `

# Find the first occurrence of the "$2" line
# and translate the output string to a line number
ST_LINE=`grep --max-count=1 --line-number $2 $1 | tr --delete ":" | cut --fields=1 --delimiter=" " `

# Decrement the number using arithmetic expansion syntax
ST_LINE=$((ST_LINE-1))

# Start the new menu file
head --lines=$ST_LINE $1 > /tmp/new.menu

# Append softworx part to it
cat $FILE_TO_INSERT >> /tmp/new.menu

# Add the leftover part of the original file
LEFTOVER=$((FILE_LEN-ST_LINE))
tail --lines=$LEFTOVER $1 >> /tmp/new.menu

# Shuffle file names
mv $1 $1_ap_save
mv /tmp/new.menu $1
