#!/bin/bash

# $Id: start_update.sh,v 1.2.8.3 2007/06/21 15:05:20 mcavelero Exp $

DATESTAMP=`date +%m%d%y_%H%M%S`

# If an md5sum file exists in this directory, verify files.
if [ -e `dirname $0`/md5sums ]; then
  echo "Verifying integrity of installation files..."
  pushd `dirname $0` > /dev/null
  if /usr/bin/md5sum --status --check md5sums; then
    echo " - installation files appear valid, continuing..."
  else
    # Repeat md5sum to display failed file(s)
    /usr/bin/md5sum --check md5sums
    popd > /dev/null
    echo "FAILED FILE INTEGRITY CHECK, ABORTING."
    echo "Press the Enter key to close."
    read ANSWER
    exit 1
  fi
  popd > /dev/null
fi

# Set up the arguments for the "rpm" command. These are passed to "update_sw.sh"

# If this is a raw install, or if it replaces i386 RPMS, we can use the "Upgrade"
# argument to install all the new RPMs. "update_sw.sh" will erase the i386
# RPMs before installing the x86_64 versions
RPMARG1=-Uvh
RPMARG2=--nodeps
RPMARG3=

# Let's figure out if this is an update of x86_64 RPMS
rpm -q --quiet softWoRx-Base.x86_64
if [ $? == 0 ]; then
  # This means that we have 64-bit versions installed. Just "Freshen" the
  # RPMs that are installed
  RPMARG1=-Fvh
fi

# Add Beta warning if required
if [ $1 ]; then
  if [ $1 = 'BETA' ]; then
    echo "WARNING: BETA SOFTWARE INSTALLATION.  **********************"
    echo "DO NOT INSTALL WITHOUT PRIOR CONSENT FROM APPLIED PRECISION."

    echo ""
    echo -n "Are you sure you want to proceed? [y/n] "
    read ANSWER

    if [ $ANSWER != 'y' ] ; then
      echo ""
	    echo "Software Update Cancelled"
	    sleep 2
	    exit -1
    fi

    RPMARG3=--force
  fi
fi

# This launches a setup script after optionally requesting root password

echo "============================================="
echo "        DeltaVision softWoRx Updater"
echo " "
echo "This utility will update DeltaVision softWoRx"
echo "  software if the packages on this disc are"
echo "    newer than those currently installed."
echo " "
echo "WARNING: Make sure the softWoRx software"
echo "        is not currently running."
echo " "
echo "============================================="

if [ `whoami` != 'root' ]; then
        echo "You will need to provide superuser (root) password for this..."
fi

echo -n "Do you want to proceed? [y/n] "
read ANSWER

if [ $ANSWER != 'y' ] ; then
  echo ""
	echo "Software Update Cancelled"
	sleep 2
	exit -1
fi


# Really make sure softWoRx isn't running...
if [ -e /usr/local/softWoRx/bin/i386/DVExit ] ; then
  /usr/local/softWoRx/bin/i386/DVExit
else 
  if [ -e /usr/local/softWoRx/bin/x86_64/DVExit ] ; then
    /usr/local/softWoRx/bin/x86_64/DVExit
  fi
fi

if [ `whoami` != 'root' ]; then
        echo ""
        echo "(Enter root password below)"
fi

# Run the Configuration Program
COMMAND="`dirname $0`/update_sw.sh $RPMARG1 $RPMARG2 $RPMARG3"
su root -c "$COMMAND"

echo " "
echo "Press the Enter key to finish"
read ANSWER
exit 0

