#!/bin/tcsh -f

# This setup script will be used to update DeltaVision softWoRx
# from a CD. Must be run as root
# Note this is a csh script, not bash!

# $Id: update_sw.sh 25962 2017-04-07 20:30:25Z jnewberry $

set DATESTAMP=`date +%m%d%y_%H%M%S`

if (-d /usr/local/softWoRx) then
    echo "Backing up old softWoRx installation to /usr/local/softWoRx_backup_"$DATESTAMP
    mkdir /usr/local/softWoRx_backup_$DATESTAMP
    cp -r /usr/local/softWoRx/bin    /usr/local/softWoRx_backup_$DATESTAMP
    cp -r /usr/local/softWoRx/lib    /usr/local/softWoRx_backup_$DATESTAMP
    cp -r /usr/local/softWoRx/config /usr/local/softWoRx_backup_$DATESTAMP
    cp -r /usr/local/softWoRx/help   /usr/local/softWoRx_backup_$DATESTAMP
endif

set RPM_SRC=`dirname $0`/..
set RPM_LOCAL=/usr/local/rpms

if !(-d $RPM_SRC/RPMS) then
    echo "RPMS directory not found at install source location."
    exit -1
endif

pushd $RPM_SRC/RPMS

set ALL_RPMS=`ls *.rpm`

if ( ${#ALL_RPMS} == '0' )  then
    echo "No RPM files found at the install source."
    exit -1
endif

echo ""
echo "Backing up software packages to /usr/local/rpms"
# Create local backup copies of all new rpms
if !(-d $RPM_LOCAL )  mkdir $RPM_LOCAL

foreach i ($ALL_RPMS)
	if !(-e $RPM_LOCAL/$i) then
		echo "copying $i to $RPM_LOCAL"
		cp $i $RPM_LOCAL
	endif
end

#
# The following will erase i386 RPMs if they exist. They will
# be replaced by 64-bit versions
#
rpm -q --quiet softWoRx-Base.i386
if($status == 0) then
  echo "Erasing deprecated softWoRx-Base.i386 RPM"
  rpm -e --nodeps softWoRx-Base.i386 
endif

rpm -q --quiet softWoRx-DV-Acquire.i386
if($status == 0) then
  echo "Erasing deprecated softWoRx-DV-Acquire.i386 RPM"
  rpm -e --nodeps softWoRx-DV-Acquire.i386 
endif

rpm -q --quiet softWoRx-DV-Analyze.i386
if($status == 0) then
  echo "Erasing deprecated softWoRx-DV-Analyze.i386 RPM"
  rpm -e --nodeps softWoRx-DV-Analyze.i386 
endif

rpm -q --quiet softWoRx-DV-Help.i386
if($status == 0) then
  echo "Erasing deprecated softWoRx-DV-Help.i386 RPM"
  rpm -e --nodeps softWoRx-DV-Help.i386 
endif

# The arguments passed to this script ($1 $2 $3) will specify Upgrade or Freshen
#
# "Upgrade" installs all the provided RPMs, including updating RPMs
# of the same architecture if they are already installed.
#
# "Freshen" will update packages if they have older versions already 
# installed and quietly ignore the other RPMs
#
# Sample arguments for RPM:  -Fvh (or -U)
#                            --nodeps
#                            --force
#                            --nopostun (don't run post uninstall scripts)
echo ""
echo "Updating software packages"
rpm $1 $2 $3 --nopostun *.rpm

if ($status == '0') then
	echo " "
	echo "softWoRx Software Packages Updated Successfully"
	echo " "
else
	echo " "
	echo "softWoRx Software Update Failed"
    exit -1
endif

# softWoRx now uses a static executable of the ffmpeg package to create movies.
#  install that package.
./support/install-ffmpeg-static.sh ./support

# reset the directory
popd

# in order that users' old desktop icons point to the appropriate
# place, put in a symbolic link from old to new
if (! -e /usr/local/softWoRx/bin/i386 ) then
    ln -s /usr/local/softWoRx/bin/x86_64 /usr/local/softWoRx/bin/i386
else
# these really have to exist
    ln -s /usr/local/softWoRx/bin/x86_64/DV /usr/local/softWoRx/bin/i386/DV
    ln -s /usr/local/softWoRx/bin/x86_64/runDV /usr/local/softWoRx/bin/i386/runDV
    ln -s /usr/local/softWoRx/bin/x86_64/DVExit /usr/local/softWoRx/bin/i386/DVExit
endif

# 
# Try to determine if the Resolve3D emulator was set up.
# This would be the case if this was a standalone workstation. 
# If so, make sure the flavor of Resolve3D Executable is
# the emulator version. Resolve3D_network will still be around
# if this happens in error...
#
if (-e /usr/local/softWoRx/config/Resolve3D.SYS ) then
  set CAMLINE=`fgrep CCD_Cam_Name /usr/local/softWoRx/config/Resolve3D.SYS`
  if ($CAMLINE[2] == 'emulator') then
    if (-e /usr/local/softWoRx/bin/i386/Resolve3D_emulator) then
      cp /usr/local/softWoRx/bin/i386/Resolve3D_emulator /usr/local/softWoRx/bin/i386/Resolve3D
    endif
    if (-e /usr/local/softWoRx/bin/x86_64/Resolve3D_emulator) then
      cp /usr/local/softWoRx/bin/x86_64/Resolve3D_emulator /usr/local/softWoRx/bin/x86_64/Resolve3D
    endif
  else
    # transmit the IC540 update
    $RPM_SRC/bin/xmit_ic_update.sh $RPM_SRC/IC

  endif
endif

# finish by copying the Release Notes to the softWoRx Help directory
cp $RPM_SRC/ReleaseNotes.html /usr/local/softWoRx/help
