#!/bin/bash

# This script installs static executables of ffmpeg.

SRCFILE=ffmpeg-git-64bit-static.tar
UNPACKDIR=ffmpeg-git-20180913-64bit-static

# check the argument 
if [ -z $1 ]; then
  echo "No installation directory provided, using default..."
  SRCDIR="`pwd`"
else
  SRCDIR=$1
fi

# confirm install source directory exists
if [ ! -d $SRCDIR ]; then
  echo "Install source directory does not exist, quiting! "
  exit 1
# confirm the install source file exists
elif [ ! -f $SRCDIR/$SRCFILE ]; then
  echo "Installer file not found in install source directory, quiting! "
  exit 1
# confirm target installation directory exists
elif [ ! -d /usr/local/bin ]; then
  echo "Destination directory /usr/local/bin does not exist, quiting! "
  exit 1
# confirm target storage directory exists
elif [ ! -d /usr/local/rpms ]; then
  echo "Archive storage directory /usr/local/rpms does not exist, quiting! "
  exit 1
fi

# remove ffmpeg if it is already installed in /usr/local/bin directory
if [ -e /usr/local/bin/ffmpeg ]; then
  echo "Removing currently installed ffmpeg..."
  rm -f /usr/local/bin/ffmpeg
fi

# copy the archive to the /usr/local/rpms directory and unpack it
echo "Storing tar package in /usr/local/rpms and unpacking..."
cp $SRCDIR/$SRCFILE /usr/local/rpms/.
pushd /usr/local/rpms
tar xvf /usr/local/rpms/$SRCFILE
popd

# copy only the ffmpeg binary to the /usr/local/bin directory
echo "Copying ffmpeg binary executable to /usr/local/bin ..."
cp /usr/local/rpms/$UNPACKDIR/ffmpeg /usr/local/bin/.

# verify success
if [ -e /usr/local/bin/ffmpeg ]; then 
  echo "Installation successful."
else
  echo "Installation failed, the ffmpeg executable was not found in expected destination."
fi

