#!/bin/bash

# This script sends a Microsoft Windows XP installer IC540
#  update file to a connected and booted IC/MIC workstation.

# $Id: xmit_ic_update.sh 20908 2012-03-22 16:16:13Z mcavelero $

CONFIG_FILE=/usr/local/softWoRx/config/Resolve3D.SYS

# check the argument 
if [ -z $1 ]; then
  echo "No install source directory provided, using default..."
  SOURCE_DIR="`pwd`/../IC"
else
  SOURCE_DIR=$1
fi

# confirm install source directory exists
if [ ! -d $SOURCE_DIR ]; then
  echo "Install source directory does not exist, quiting! "
  exit 1
# confirm the install source file exists
elif [ ! -f $SOURCE_DIR/IC540_XP_installer.msi ]; then
  echo "Installer file not found in install source directory, quiting! "
  exit 1
fi

# do nothing if emulator is installed
if grep -qe "PC_Type: *network" $CONFIG_FILE; then
 
  # determine if IC/MIC is reachable
  if ! ping -c 1 dvic >/dev/null 2>/dev/null; then
    # Confirm the IC/MIC is ready for incoming files (is it on?) 
    echo "The software updater is now ready to send the update for the Instrument"
    echo "Controller.  Please verify the Instrument Controller is on."
    echo
    echo -n "Press enter when ready > "
    read I_DUMMY
  fi

  # use smbclient to send the installer file to the IC/MIC
  pushd $SOURCE_DIR >/dev/null

  if grep -qe "release 6." /etc/redhat-release; then
    smbclient //159.159.159.2/c$ -U worx 4delta -c "cd \\ic540_dv\\bin; setmode APUpdate.bat -rh; put APUpdate.bat"
    smbclient //159.159.159.2/apupdates -U worx 4delta -c "put IC540_XP_installer.msi" > output.txt
    # we expect file transfer to fail if CentOS 6 and Win10 IC/MIC
    if grep -qe "CONNECTION_RESET" output.txt; then
      echo
      echo "Failed to send IC540_XP_installer.msi to Instrument Controller..."
      echo "Please refer to `pwd`/DV_IC540_Installation_on_Windows_10.pdf for manual transfer and installation."
      echo
      echo -n "Press enter key to continue > "
      read I_DUMMY
    fi
  fi

  if grep -qe "release 7." /etc/redhat-release; then
    pushd $SOURCE_DIR/x64 >/dev/null
    smbclient //159.159.159.2/apupdates -U worx 4delta -c "get APUpdate.bat" > output.txt
    # must be Win7
    if grep -qe "NOT_FOUND" output.txt; then
      popd >/dev/null
      # replace the update script to avoid potential installer hang
      smbclient //159.159.159.2/c$ -U worx 4delta -c "cd \\ic540_dv\\bin; setmode APUpdate.bat -rh; put APUpdate.bat"
      # place the installer
      smbclient //159.159.159.2/apupdates -U worx 4delta -c "put IC540_XP_installer.msi"
    # must be Win10
    else
      popd >/dev/null
      # replace the update script to avoid potential installer hang
      smbclient //159.159.159.2/apupdates -U worx 4delta -c "setmode APUpdate.bat -rh; put APUpdate.bat"
      pushd $SOURCE_DIR/x64 >/dev/null
      # place the installer
      smbclient //159.159.159.2/apupdates -U worx 4delta -c "put IC540_XP_installer.msi"
    fi
  fi

  popd >/dev/null
fi
