#!/bin/bash

# This launches a setup script after optionally requesting root password

EXTRA_ARGS="$1 $2 $3"

SOURCE="ftp.api.com/pub/dv_updates/"

SW_BASE=/usr/local/softWoRx

echo " "
echo " "
echo "-------------------------------------------------"
echo "     DeltaVision softWoRx Software Updater"
echo " "
echo "       This utility will update softWoRx "
echo "         workstation software packages"
echo " "
echo " The Updater requires FTP access to the Internet"
echo "-------------------------------------------------"

if [ `whoami` != 'root' ]; then
        echo ""
        echo "You will need to provide superuser (root) password for this..."
        echo ""
fi

echo "If softWoRx is running, it will be shut down for you."
echo "" 
echo -n "Do you want to proceed? [y/n] "
read ANSWER

if [ $ANSWER != 'y' ] ; then
    echo ""
	echo "Software Update Cancelled"
    sleep 3
	exit -1
fi

# Make sure softWoRx isn't running (quietly)
$SW_BASE/bin/i386/DVExit > /dev/null 2>&1

echo ""
echo "Downloading the software updater program..."
cd /tmp
ncftpget -V -F ftp://$SOURCE/sw_updater

if [ $? != 0 ]; then
    echo ""
    echo "Passive FTP transfer failed. Trying Non-Passive"
    ncftpget -V -E ftp://$SOURCE/sw_updater
fi

if [ $? -ne 0 ]; then
    echo "***********************************************"
    echo "ERROR: Could not download the software updater"
    echo "from: $SOURCE"
    echo "***********************************************"
    echo ""
    echo "[hit Enter to finish]"
    echo ""
    read DUMMY
    exit -1
fi

chmod +x /tmp/sw_updater
xhost + >/dev/null

if [ `whoami` != 'root' ]; then
  echo ""
  echo "(Enter root password below)"
fi

# Run the Configuration Program

COMMAND="/tmp/sw_updater -i $EXTRA_ARGS -r $SOURCE -p dv"

su root -c "$COMMAND" 

rm -f /tmp/sw_updater
